/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.game.EntityJumpEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.Render3DEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.settings.BooleanSetting;
import Krasnodar.rockstarnew.systems.setting.settings.ColorSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@ModuleInfo(name="Jump Circle", category=ModuleCategory.VISUALS, desc="\u042d\u0444\u0444\u0435\u043a\u0442 \u043a\u0440\u0443\u0433\u043e\u0432 \u043f\u0440\u0438 \u043f\u0440\u044b\u0436\u043a\u0435")
public class JumpCircle
extends BaseModule {
    private final List<Circle> circles = new ArrayList<Circle>();
    final class_2960 circleTexture = Rockstar.id("textures/circle.png");
    final class_2960 glowTexture = Rockstar.id("textures/bloom.png");
    final SliderSetting maxSize = new SliderSetting(this, "Max Size").min(1.0f).max(5.0f).step(0.1f).currentValue(2.0f);
    final SliderSetting speed = new SliderSetting(this, "Speed").min(1000.0f).max(5000.0f).step(100.0f).currentValue(2000.0f);
    final BooleanSetting glow = new BooleanSetting(this, "Glow").enabled(true);
    final SliderSetting fadeInSpeed = new SliderSetting(this, "\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u044f").min(0.05f).max(0.5f).step(0.05f).currentValue(0.15f);
    final ColorSetting color1 = new ColorSetting(this, "\u0426\u0432\u0435\u0442 1").color(new ColorRGBA(137.0f, 97.0f, 72.0f, 255.0f));
    final ColorSetting color2 = new ColorSetting(this, "\u0426\u0432\u0435\u0442 2").color(new ColorRGBA(255.0f, 255.0f, 255.0f, 255.0f));
    final BooleanSetting rainbow = new BooleanSetting(this, "\u0420\u0430\u0434\u0443\u0436\u043d\u044b\u0439").enabled(false);
    private static final int SEGMENTS = 64;
    private final EventListener<EntityJumpEvent> onJump = event -> {
        if (JumpCircle.mc.field_1724 == null || event.getEntity() != JumpCircle.mc.field_1724) {
            return;
        }
        class_243 pos = new class_243(JumpCircle.mc.field_1724.method_23317(), Math.floor(JumpCircle.mc.field_1724.method_23318()) + 0.001, JumpCircle.mc.field_1724.method_23321());
        this.circles.add(new Circle(pos, System.currentTimeMillis()));
    };
    private final EventListener<Render3DEvent> onRender3D = event -> {
        long maxTime = (long)this.speed.getCurrentValue();
        Iterator<Circle> iterator = this.circles.iterator();
        while (iterator.hasNext()) {
            Circle circle = iterator.next();
            if (System.currentTimeMillis() - circle.startTime <= maxTime) continue;
            iterator.remove();
        }
        if (!this.circles.isEmpty()) {
            class_4587 matrices = event.getMatrices();
            class_243 cameraPos = JumpCircle.mc.field_1773.method_19418().method_19326();
            for (Circle circle : this.circles) {
                this.renderSingleCircle(matrices, circle, cameraPos);
            }
        }
    };

    @Override
    public void onEnable() {
        super.onEnable();
        this.circles.clear();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.circles.clear();
    }

    private void renderSingleCircle(class_4587 matrices, Circle circle, class_243 cameraPos) {
        float alpha;
        float maxTime;
        long lifeTime = System.currentTimeMillis() - circle.startTime;
        float progress = Math.min((float)lifeTime / (maxTime = this.speed.getCurrentValue()), 1.0f);
        if (progress >= 1.0f) {
            return;
        }
        float easedProgress = this.bounceOut(progress);
        float scale = easedProgress * this.maxSize.getCurrentValue();
        float fadeInDuration = this.fadeInSpeed.getCurrentValue();
        float glowStart = 0.65f;
        float fadeOutStart = 0.85f;
        if (progress < fadeInDuration) {
            alpha = progress / fadeInDuration;
        } else if (progress >= fadeOutStart) {
            float fadeOutProgress = (progress - fadeOutStart) / (1.0f - fadeOutStart);
            alpha = 1.0f - fadeOutProgress;
            if (progress > glowStart) {
                float glowProgress = (progress - glowStart) / (fadeOutStart - glowStart);
                float glowPulse = (float)(Math.sin((double)glowProgress * Math.PI * 3.0) * 0.3 + 0.3);
                alpha += glowPulse * (1.0f - fadeOutProgress);
            }
        } else if (progress > glowStart) {
            float glowProgress = (progress - glowStart) / (fadeOutStart - glowStart);
            float glowPulse = (float)(Math.sin((double)glowProgress * Math.PI * 3.0) * 0.3 + 0.3);
            alpha = 1.0f + glowPulse;
        } else {
            alpha = 1.0f;
        }
        alpha = Math.max(0.0f, Math.min(1.0f, alpha));
        float rotationOffset = (float)lifeTime / 1000.0f * 0.5f * 360.0f;
        class_243 circlePos = circle.pos;
        if (this.glow.isEnabled()) {
            this.renderGradientGlow(matrices, circlePos, scale, alpha * 0.1f, rotationOffset, cameraPos);
        }
        this.renderGradientCircle(matrices, circlePos, scale, alpha, rotationOffset, cameraPos);
    }

    private void renderGradientCircle(class_4587 matrices, class_243 pos, float size, float alpha, float rotationOffset, class_243 cameraPos) {
        matrices.method_22903();
        float x = (float)(pos.field_1352 - cameraPos.field_1352);
        float y = (float)(pos.field_1351 - cameraPos.field_1351);
        float z = (float)(pos.field_1350 - cameraPos.field_1350);
        matrices.method_46416(x, y, z);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        Matrix4f matrix = matrices.method_23760().method_23761();
        float radius = size / 2.0f;
        ColorRGBA c1 = this.color1.getColor();
        ColorRGBA c2 = this.color2.getColor();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (class_2960)this.circleTexture);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 buffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        for (int i = 0; i < 64; ++i) {
            float angle1 = (float)(Math.PI * 2 * (double)i / 64.0);
            float angle2 = (float)(Math.PI * 2 * (double)(i + 1) / 64.0);
            float t = (float)i / 64.0f;
            float tNext = (float)(i + 1) / 64.0f;
            float adjustedT = (t + rotationOffset / 360.0f) % 1.0f;
            float adjustedTNext = (tNext + rotationOffset / 360.0f) % 1.0f;
            ColorRGBA currentColor = this.getGradientColor(c1, c2, adjustedT, alpha);
            ColorRGBA nextColor = this.getGradientColor(c1, c2, adjustedTNext, alpha);
            float x1 = (float)(Math.cos(angle1) * (double)radius);
            float z1 = (float)(Math.sin(angle1) * (double)radius);
            float x2 = (float)(Math.cos(angle2) * (double)radius);
            float z2 = (float)(Math.sin(angle2) * (double)radius);
            float u1 = (float)(0.5 + 0.5 * Math.cos(angle1));
            float v1 = (float)(0.5 + 0.5 * Math.sin(angle1));
            float u2 = (float)(0.5 + 0.5 * Math.cos(angle2));
            float v2 = (float)(0.5 + 0.5 * Math.sin(angle2));
            ColorRGBA centerColor = currentColor.mix(nextColor, 0.5f);
            buffer.method_22918(matrix, 0.0f, 0.0f, 0.0f).method_22913(0.5f, 0.5f).method_22915(centerColor.getRed(), centerColor.getGreen(), centerColor.getBlue(), centerColor.getAlpha());
            buffer.method_22918(matrix, x1, z1, 0.0f).method_22913(u1, v1).method_22915(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), currentColor.getAlpha());
            buffer.method_22918(matrix, x2, z2, 0.0f).method_22913(u2, v2).method_22915(nextColor.getRed(), nextColor.getGreen(), nextColor.getBlue(), nextColor.getAlpha());
            buffer.method_22918(matrix, x2, z2, 0.0f).method_22913(u2, v2).method_22915(nextColor.getRed(), nextColor.getGreen(), nextColor.getBlue(), nextColor.getAlpha());
        }
        class_9801 builtBuffer = buffer.method_60794();
        if (builtBuffer != null) {
            class_286.method_43433((class_9801)builtBuffer);
        }
        matrices.method_22909();
    }

    private void renderGradientGlow(class_4587 matrices, class_243 pos, float scale, float alpha, float rotationOffset, class_243 cameraPos) {
        ColorRGBA c1 = this.color1.getColor();
        ColorRGBA c2 = this.color2.getColor();
        for (int layer = 0; layer < 3; ++layer) {
            float layerScale = scale * (1.3f + (float)layer * 0.4f);
            float layerAlpha = alpha * (0.35f - (float)layer * 0.1f);
            this.renderGlowLayer(matrices, pos, layerScale, layerAlpha, rotationOffset, c1, c2, cameraPos);
        }
        float coreAlpha = alpha * 0.2f;
        ColorRGBA coreColor1 = c1.withAlpha(coreAlpha * 255.0f);
        ColorRGBA coreColor2 = c2.withAlpha(coreAlpha * 255.0f);
        ColorRGBA mixedCore = coreColor1.mix(coreColor2, 0.5f);
        this.renderTexturedQuad(matrices, pos, scale * 2.5f, mixedCore, this.glowTexture, cameraPos);
    }

    private void renderGlowLayer(class_4587 matrices, class_243 pos, float size, float alpha, float rotationOffset, ColorRGBA c1, ColorRGBA c2, class_243 cameraPos) {
        int glowSegments = 16;
        float radius = size / 2.0f;
        for (int i = 0; i < glowSegments; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)glowSegments);
            float t = (float)i / (float)glowSegments;
            float adjustedT = (t + rotationOffset / 360.0f) % 1.0f;
            ColorRGBA glowColor = this.getGradientColor(c1, c2, adjustedT, alpha);
            float glowX = (float)(pos.field_1352 + Math.cos(angle) * (double)radius * (double)0.8f);
            float glowZ = (float)(pos.field_1350 + Math.sin(angle) * (double)radius * (double)0.8f);
            class_243 glowPos = new class_243((double)glowX, pos.field_1351, (double)glowZ);
            float glowSize = size * 0.4f;
            this.renderTexturedQuad(matrices, glowPos, glowSize, glowColor, this.glowTexture, cameraPos);
        }
    }

    private ColorRGBA getGradientColor(ColorRGBA c1, ColorRGBA c2, float t, float alpha) {
        float gradientT = t <= 0.5f ? t * 2.0f : (1.0f - t) * 2.0f;
        ColorRGBA color = c1.mix(c2, gradientT);
        return color.withAlpha(alpha * 255.0f);
    }

    private void renderTexturedQuad(class_4587 matrices, class_243 pos, float size, ColorRGBA color, class_2960 texture, class_243 cameraPos) {
        matrices.method_22903();
        float x = (float)(pos.field_1352 - cameraPos.field_1352);
        float y = (float)(pos.field_1351 - cameraPos.field_1351);
        float z = (float)(pos.field_1350 - cameraPos.field_1350);
        matrices.method_46416(x, y, z);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        Matrix4f matrix = matrices.method_23760().method_23761();
        float half = size / 2.0f;
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        class_287 buffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22918(matrix, -half, -half, 0.0f).method_22913(0.0f, 0.0f).method_22915(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        buffer.method_22918(matrix, half, -half, 0.0f).method_22913(1.0f, 0.0f).method_22915(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        buffer.method_22918(matrix, half, half, 0.0f).method_22913(1.0f, 1.0f).method_22915(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        buffer.method_22918(matrix, -half, half, 0.0f).method_22913(0.0f, 1.0f).method_22915(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        class_9801 builtBuffer = buffer.method_60794();
        if (builtBuffer != null) {
            class_286.method_43433((class_9801)builtBuffer);
        }
        matrices.method_22909();
    }

    private float bounceOut(float value) {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (value < 1.0f / d1) {
            return n1 * value * value;
        }
        if (value < 2.0f / d1) {
            return n1 * (value -= 1.5f / d1) * value + 0.75f;
        }
        if (value < 2.5f / d1) {
            return n1 * (value -= 2.25f / d1) * value + 0.9375f;
        }
        return n1 * (value -= 2.625f / d1) * value + 0.984375f;
    }

    private static class Circle {
        final class_243 pos;
        final long startTime;

        Circle(class_243 pos, long startTime) {
            this.pos = pos;
            this.startTime = startTime;
        }
    }
}

